/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.Plane;

public record Sphere(class_243 center, double radius) {
    @Nullable
    public class_243 projectToSphere(class_243 pos) {
        class_243 delta = pos.method_1020(this.center());
        if (delta.method_1027() < 0.001) {
            return null;
        }
        return this.center().method_1019(delta.method_1029().method_1021(this.radius()));
    }

    @Nullable
    public Circle getIntersectionWithPlane(Plane plane) {
        double distance = plane.getDistanceTo(this.center());
        if (distance > this.radius()) {
            return null;
        }
        class_243 circleCenter = plane.getProjection(this.center());
        double newRadius = Math.sqrt(this.radius() * this.radius() - distance * distance);
        return new Circle(plane, circleCenter, newRadius);
    }

    @Nullable
    public class_243 rayTrace(class_243 lineOrigin, class_243 lineVec) {
        double c;
        class_243 delta = lineOrigin.method_1020(this.center());
        double a = lineVec.method_1027();
        double b = delta.method_1026(lineVec) * 2.0;
        double discriminant = b * b - 4.0 * a * (c = delta.method_1027() - this.radius() * this.radius());
        if (discriminant < 0.0) {
            return null;
        }
        double sqrtDiscriminant = Math.sqrt(discriminant);
        double t1 = (-b + sqrtDiscriminant) / (2.0 * a);
        double t2 = (-b - sqrtDiscriminant) / (2.0 * a);
        if (t1 < 0.0 && t2 < 0.0) {
            return null;
        }
        if (t1 < 0.0) {
            return lineOrigin.method_1019(lineVec.method_1021(t2));
        }
        if (t2 < 0.0) {
            return lineOrigin.method_1019(lineVec.method_1021(t1));
        }
        return lineOrigin.method_1019(lineVec.method_1021(Math.min(t1, t2)));
    }

    public static Sphere interpolate(Sphere a, Sphere b, double progress) {
        return new Sphere(a.center().method_35590(b.center(), progress), class_3532.method_16436((double)progress, (double)a.radius(), (double)b.radius()));
    }
}

